//	CFolderCpm.h

#ifndef _H_CFolderCpm
#define _H_CFolderCpm

#include "CFolder.h"
#include "CpmStructs.h"

typedef		OSErr	Cpm_ForEachEntryCB(
	CFolderCpm			*thiz, 
	Cpm_DirEntry		*entry, 
	Cpm_BlockNum		blockNum, 
	Cpm_EntryIndex		entryIndex, 
	Boolean				*done, 
	void				*data);

class CFolderCpm : public CFolder {

	public:	
	
	OSErr	IFolderCpm(
		CDiskCpm			*cDiskCpm);

	virtual	void	Dispose(void);
	
	OSErr			Cpm_ForEachEntry(
		Cpm_ForEachEntryCB	Cpm_ForEachUserCB, 
		void				*data);

	static	OSErr	Cpm_MakeNewEntryCB(
		CFolderCpm			*thiz, 
		Cpm_DirEntry		*entryP, 
		Cpm_BlockNum		blockNum, 
		Cpm_EntryIndex		entryIndex, 
		Boolean				*done, 
		void				*data);

	OSErr			Cpm_MakeNewEntry(
		Cpm_DirEntry		*entry, 
		Cpm_BlockNum		blockNum, 
		Cpm_EntryIndex		entryIndex, 	//	within cur sector
		Cpm_EntryIndex		directoryIndex, //	within entire catalog
		CEntry				**newEntry0);

	Boolean			GetEmptyEntry(Cpm_EntryIndex *entryIndexP);
	Boolean			GetUniqueName(char *fileName);

	OSErr	NewFile(Boolean isFolder, CEntry **entryH);
	OSErr	Cpm_DeleteEntry(Cpm_EntryIndex entryIndex);

	Cpm_DirEntry	*GetEntry(Cpm_EntryIndex entryIndex);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	private:
	typedef CFolder _inherited;
};


#endif
